/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.requests;

import com.ibm.hwmca.base.rsf.handlers.RetainUtils;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.rsf.XFrameRsfRequestBody;

public class LicccRequestBody
extends XFrameRsfRequestBody {
    private static String TRACE_MASKT = "XRSFBRQT";
    private static String TRACE_MASKF = "XRSFBRQF";
    private static String TRACE_MASKD = "XRSFBRQD";
    public static char RV_CEC = '\u0000';
    public static char RV_MEM = '\u0001';
    public static char RV_CEC_AND_EBU = (char)2;
    public static char RV_PMI = (char)3;
    public static char RV_EBU_PW = (char)4;
    public static char RV_CHANNEL = (char)5;
    public static char RV_ISC3 = (char)6;
    public static char RV_CUOD = (char)7;
    public static char RV_CEC_AND_CIU = (char)8;
    public static char RV_MEM_AND_CIU = (char)9;
    public static char RV_CEC_AND_EBU_AND_CIU = (char)10;
    public static String RSF_PERMANENT_AP_DATA = "Ap data";
    public static String RSF_CAPACITY_BACKUP_DATA = "Ebu data";
    public static String RSF_ADDITIONAL_AP_DATA = "Pmi data";
    public static String RSF_CAPACITY_BACKUP_PW = "Ebu pw";
    public static String RSF_CURRENT_SERIAL = "Current Serial";
    public static String RSF_NEW_SERIAL = "New Serial";
    public static String RSF_ORDER_NUMBER = "Order Number";
    public static String RSF_POWER_ON_HOURS = "Power On Hours";
    private static String EBCDIC = "Cp500";

    public LicccRequestBody() {
        this.functionUserid = (char)66;
    }

    public LicccRequestBody(PersistentData data) {
        super(((Persistent)data).parentData);
    }

    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.parentData = super.getPersistentData();
        return result;
    }

    public void putAttribute(String attributeName, String attributeValue) {
        if (attributeName.equals(RSF_PERMANENT_AP_DATA) || attributeName.equals(RSF_CAPACITY_BACKUP_DATA) || attributeName.equals(RSF_ADDITIONAL_AP_DATA)) {
            this.putByteAttribute(attributeName, attributeValue.getBytes());
        } else {
            super.putAttribute(attributeName, attributeValue);
        }
    }

    public boolean isValid() {
        return super.isValid() && this.functionId != ' ';
    }

    public void setApData(byte[] data) {
        this.putByteAttribute(RSF_PERMANENT_AP_DATA, data);
    }

    public void setCbuData(byte[] data) {
        this.putByteAttribute(RSF_CAPACITY_BACKUP_DATA, data);
    }

    public void setPmiData(byte[] data) {
        this.putByteAttribute(RSF_ADDITIONAL_AP_DATA, data);
    }

    public void putByteAttribute(String attributeName, byte[] attributeData) {
        byte[] attrLength = RetainUtils.calcLength(attributeData.length + 2);
        try {
            String attributeValue = new String(attrLength, 0, attrLength.length, EBCDIC) + new String(attributeData, 0, attributeData.length, EBCDIC);
            this.attributes.put(attributeName, attributeValue);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "LicccRequestBody: unable to add attribute:" + attributeName);
            Trace.trace(TRACE_MASKF, e);
        }
    }

    public void setFunctionType(char type) {
        this.functionId = type;
    }

    public char getFunctionType() {
        return this.functionId;
    }

    public String toXmlTransferFormat() {
        StringBuffer buffer = new StringBuffer(this.buildUseridAndFunction());
        buffer.append(super.toXmlTransferFormat());
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.buildUseridAndFunction());
        buffer.append(super.toString());
        return buffer.toString();
    }

    private static class Persistent
    implements PersistentData {
        PersistentData parentData;
        int version = 0;
        private static final long serialVersionUID = 1L;

        private Persistent() {
        }
    }
}

